import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';
import { ConceptServices } from '../../../services/concept-services';
import { MvpServices } from '../../../services/mvp-services';
import { RoleServices } from '../../../services/role-services';

@Component({
  selector: 'app-concept-card-description', //<app-concept-card-item></app-concept-card-item>
  templateUrl: './concept-card-description.component.html',
  styleUrls: ['./concept-card-description.component.scss']
})
export class ConceptCardDescriptionComponent implements OnInit {
  @Input() description;
  @Input() parent;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
  	private conceptServices: ConceptServices,
    public mvpServices: MvpServices,
    private roleServices: RoleServices,
    private ngRedux: NgRedux<IAppState>) {
  }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  isAvailable(objects) {
    return objects !== null && objects.length > 0;
  }

  getAddMvpState() {
    return this.getState().conceptCard.mvpAddState;
  }

  hasMvpAddRole(mvpAnnotation) {
    var mvpBooleanState = false;
    switch(mvpAnnotation) {
      case 'definition':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddDefinition;
        break;
      case 'alt-definition':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddAltDefinition;
        break;
      case 'synonym':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddSynonym;
        break;
    }
    return this.roleServices.isTerminologist() && mvpBooleanState && this.mvpServices.isConceptMvp();
  }

}
